clear all; close all; clc

load('D50_a.mat');
load('D50_b.mat');
load('D100_a.mat');
load('D100_b.mat');
load('D200_a.mat');
load('D200_b.mat');
load('D300_a.mat');
load('D300_b.mat');
load('D400_a.mat');
load('D400_b.mat');


Tb1_monthly_avg=[Tb1_monthly_avg_a' Tb1_monthly_avg_b Tb1_monthly_avg_c Tb1_monthly_avg_d Tb1_monthly_avg_e];
Tb1_std=[Tb1_std_a' Tb1_std_b Tb1_std_c Tb1_std_d Tb1_std_e]; 

Tf1_monthly_avg=[Tf1_monthly_avg_a' Tf1_monthly_avg_b Tf1_monthly_avg_c Tf1_monthly_avg_d Tf1_monthly_avg_e ];
Tf1_std=[Tf1_std_a' Tf1_std_b Tf1_std_c Tf1_std_d Tf1_std_e]; 


figure(1)
subplot(2,1,1)
errorbar(1:12, Tb1_monthly_avg, Tb1_std, 'o-', 'LineWidth', 1.5);
legend('COP = 2 ','COP = 3.3  ', 'COP = 4.75 ', 'COP = 6.13 ','COP=7.5');
set(gca,'fontsize',25)
grid on;
title('Temperature profile (Borehole)');
xlabel('Time (month)');
ylabel('Temperature (°C)');

subplot(2,1,2)
errorbar(1:12, Tf1_monthly_avg, Tf1_std, 'o-', 'LineWidth', 1.5);
legend('COP = 2 ','COP = 3.3  ', 'COP = 4.75 ', 'COP = 6.13 ','COP=7.5');
set(gca,'fontsize',25)
grid on;
title('Temperature profile (Fluid)');
xlabel('Time (month)');
ylabel('Temperature (°C)');